/* Simple Console (DOS box) application for polled mode Analog Output

   Tested with KPCI-3130 in Win2K SP1 using 3130-850A03

*/

#include <windows.h>  //  need these include files
#include "drvlinx.h"  // copied these to the project's folder
#include "dlcodes.h"

void showMessage(DL_ServiceRequest *SR);
HINSTANCE DriverInst;
DL_ServiceRequest * SerReq;


void showMessage(DL_ServiceRequest *SR)
{
	if(SR->result!=0)
	{
		SR->operation=MESSAGEBOX;
		DriverLINX(SR);
		exit(0);
	}
	return;
}



int main(int argc, char* argv[])
{

	//Open the driver, in this case the kpci3130 for the KPCI-3130 or KPCI-3132 boards
	// OpenDriverLINX function wants a valid window handle in anticipation
	// that we might make use of Windows Messages.  Use of Messages is not
	// relavent to our DOS-box application so just pass the handle of the desktop to this function
	DriverInst = OpenDriverLINX(GetDesktopWindow(), "kpci3130");
	
	// allocate the SR structure
	SerReq = (DL_ServiceRequest*) new DL_ServiceRequest;
	memset(SerReq,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*SerReq);
	
	// use the SR structure to initialize the hardware
	SerReq->device=0;  // the device number assigned in DLinx Config Panel
	SerReq->operation=INITIALIZE;
	SerReq->mode=OTHER;
	SerReq->subsystem=DEVICE;
	SerReq->hWnd=GetDesktopWindow();
	DriverLINX(SerReq);  // carry out the INITIALIZE operation
	showMessage(SerReq);  // call the error checking routine

	//now modify the members of the structure to carry out a POLLED mode START operation
	SerReq->subsystem = AO;
	SerReq->operation = START;
	SerReq->mode=POLLED;
	SerReq->channels.nChannels=1;  // only one channel involved in the task
	SerReq->channels.chanGain[0].channel=0;  // that channel is chan 0
	SerReq->status.typeStatus=IOVALUE;  // in the ioValue member we'll send data
	// the Volts2Code function can determine for you how many DAC counts
	// equate to the requested voltage value for the specified channel.
	SerReq->status.u.ioValue = Volts2Code(0, AO, 2.5f);  // write 2.5 volts to chan 0
	DriverLINX(SerReq);  // carry out the START operation
	showMessage(SerReq);  // error check

	// on exit, close the driver and set the structures to null
	
	CloseDriverLINX(DriverInst);
	delete (SerReq);
	DriverInst = NULL;
	SerReq = NULL;   
	
	return 0;
}

